import warnings
warnings.filterwarnings("ignore")

import re, statsapi
import numpy as np

from colorama import init, Style
init()

def bold(text):
	print(Style.BRIGHT+text+Style.RESET_ALL)

def process_game(item):
	game_time=re.search("T([0-9]+):([0-9]+)",item['gameDate'])
	game_time_hour=int(game_time[1])
	game_time_hour-=5
	if game_time_hour<0:
		game_time_hour+=12
	if game_time_hour>12:
		game_time_hour-=12
	game_time_min=game_time[2]
	if item['status']['statusCode']=='F': #If the game is final, correct record to pre-game state
		if item['teams']['away']['isWinner']:
			item['teams']['away']['leagueRecord']['wins']-=1
			item['teams']['home']['leagueRecord']['losses']-=1
		elif item['teams']['home']['isWinner']:
			item['teams']['away']['leagueRecord']['losses']-=1
			item['teams']['home']['leagueRecord']['wins']-=1
	game={
		'ID': item['gamePk'],
		'Away Team': item['teams']['away']['team']['name'],
		'Away Team ID': item['teams']['away']['team']['id'],
		'Home Team': item['teams']['home']['team']['name'],
		'Home Team ID': item['teams']['home']['team']['id'],
		#'Index': game_index,
		'Game Time': str(game_time_hour)+":"+game_time_min,
		'gameType': item['gameType'],
		'season': item['season'],
		'away_record': item['teams']['away']['leagueRecord'],
		'home_record': item['teams']['home']['leagueRecord']
	}
	
	return game
	
def process_schedule(schedule):
	if len(schedule['dates'])>0:
		games={
			i: {**process_game(item)} 
			for i, item in enumerate(schedule['dates'][0]['games'], start=1)
		}
	elif len(schedule['dates'])==0:
		games={}
		
	if len(schedule['dates'])>0:
		date=schedule['dates'][0]['date']
		print("")
		bold("Date: "+date)
		print("")
	
		date_comp=re.search("([0-9]+)\-([0-9]+)\-([0-9]+)",date)
		year=date_comp[1]
		month=date_comp[2]
		day=date_comp[3]
		if month=="01":
			month_str="January"
		if month=="02":
			month_str="February"
		if month=="03":
			month_str="March"
		if month=="04":
			month_str="April"
		if month=="05":
			month_str="May"
		if month=="06":
			month_str="June"
		if month=="07":
			month_str="July"
		if month=="08":
			month_str="August"
		if month=="09":
			month_str="September"
		if month=="10":
			month_str="October"
		if month=="11":
			month_str="November"
		if month=="12":
			month_str="December"
	elif len(schedule['dates'])==0:
		year=np.nan
		month=np.nan
		day=np.nan
		month_str=""
	
	return games, year, month, day, month_str
	
def present_games(games):
	max_index=len(games)
	
	print("")
	if max_index>0:
		bold("Select the number of the game that you want to score.")
	
		for index, game in games.items():
			print(str(index)+". "+game['Away Team']+" at "+game['Home Team']+", "+game['Game Time']+"CT")
	
	elif max_index==0:
		bold("No games scheduled.")
		
	print("")
	
	bold("Or select an option.")
	print("A. Toggle manual mode")
	print("B. Change dates")
	print("C. Change leagues")
	print("D. Toggle detailed stats")
	print("E. Toggle records")
	print("F. Toggle logos")
		
	return max_index
	
def extract_selection(games,selection):
	game=games.get(selection)
	return game
	
def get_date():	
	polling=1
	while polling==1:
		month=input("Month\n > ").strip()
		try:
			month=int(month)
			if month<1 or month>12:
				print("Invalid selection. Try again.")
			else:
				polling=0
		except:
			print("Invalid selection. Try again.")
	
	if month>=10:
		month=str(month)
	elif month<10:
		month="0"+str(month)
	
	polling=1
	while polling==1:
		day=input("Day\n > ").strip()
		try:
			day=int(day)
			if day<1 or day>31:
				print("Invalid selection. Try again.")
			else:
				polling=0
		except:
			print("Invalid selection. Try again.")
			
	if day>=10:
		day=str(day)
	elif day<10:
		day="0"+str(day)
		
	polling=1
	while polling==1:
		year=input("Year\n > ").strip()
		try:
			year=int(year)
			if year<2010:
				print("Invalid selection. Try again.")
			else:
				polling=0
		except:
			print("Invalid selection. Try again.")
			
	year=str(year)
	
	date=year+"-"+month+"-"+day
	return date
	
def get_sport():
	sports={
	1: {'id':1,'name':'MLB'},
	2: {'id': 11, 'name':'AAA'},
	3: {'id': 12, 'name':'AA'},
	4: {'id': 13, 'name':'High-A'},
	5: {'id': 14, 'name':'Low-A'},
	6: {'id': 16, 'name':'Rookie'},
	7: {'id': 17, 'name':'Winter Leagues'},
	8: {'id': 23, 'name':'LMB'},
	9: {'id': 51, 'name':'WBC'}
	}
	#SportIDs are at https://statsapi.mlb.com/api/v1/sports/
	
	print("")
	bold("Select a league.")
	print("")
	
	for index, sport in sports.items():
		print(str(index)+". "+sport.get('name'))
	
	while True:
		selection=input(" > ").strip()
		
		if selection.isdigit():
			selected_sport_index=int(selection)
			if selected_sport_index<=9 and selected_sport_index>0:
				sportID=sports.get(selected_sport_index)['id']
				sport_name=sports.get(selected_sport_index)['name']
				print("Switching to "+sport_name+" mode.")
				return sportID
			else:
				print("Invalid input. Try again")
				continue
		else:
			print("Invalid input. Try again.")
			continue
		
	
def select_game():
	manual_mode=0
	full_stats=1
	sportID=1
	records=1
	show_logos=1
	date=""
	schedule=statsapi.get("schedule",{"sportId":1})

	games, year, month, day, month_str=process_schedule(schedule)
	
	max_index=present_games(games)
	
	while True:
		selection=input(" > ").strip()
		
		if selection.isdigit():
			selected_game_index=int(selection)
			if selected_game_index<=max_index and selected_game_index>0:
				game=extract_selection(games,selected_game_index)
				return game, manual_mode, year, month, day, month_str, sportID, full_stats, records, show_logos
			else:
				print("Invalid input. Try again")
		elif selection in ["A","a"]:
			manual_mode=1-manual_mode
			if manual_mode==1:	
				print("Manual mode activated.")
			elif manual_mode==0:
				print("Manual mode de-activated.")
		elif selection in ["B","b"]:
			print("")
			bold("What date's schedule do you want to see?")
			date=get_date()
			schedule=statsapi.get("schedule",{"sportId":sportID,"date":date})
			games, year, month, day, month_str=process_schedule(schedule)
			max_index=present_games(games)
		elif selection in ["C","c"]:
			sportID=get_sport()
			if date=="":
				schedule=statsapi.get("schedule",{"sportId":sportID})
			else:
				schedule=statsapi.get("schedule",{"sportId":sportID,"date":date})
			games, year, month, day, month_str=process_schedule(schedule)
			max_index=present_games(games)
		elif selection in ["D","d"]:
			full_stats=1-full_stats
			if full_stats==1:	
				print("Full stats on.")
			elif full_stats==0:
				print("Full stats off.")
		elif selection in ["E","e"]:
			records=1-records
			if records==1:	
				print("Records on.")
			elif records==0:
				print("Records hidden.")
		elif selection in ["F","f"]:
			show_logos=1-show_logos
			if show_logos==1:	
				print("Logos on.")
			elif show_logos==0:
				print("Logos off.")
		else:
			print("Invalid input. Try again")
	
'''
Get game logic
	Get today's schedule for mlb
		If there are games - present them
		If no games, say so
	Possible selections:
		Game -> Done
		Change mode -> Don't need to present any information
		Change date -> Get new date -> Present or say none -> Return to possible selections
		Change league -> Get new league -> Present or say none -> Return to possible selections
	Return sportId, manual mode, date, game
'''
	
	