from prettytable import PrettyTable
import pandas as pd
from colorama import init, Style
init()

import warnings
warnings.filterwarnings("ignore")
import statsapi

def bold(text):
	print(Style.BRIGHT+text+Style.RESET_ALL)
	
def extract(df, row, col, default=''):
    if 0 <= row < len(df):
        return df.loc[row, col]
    return default

def manual_tables(away_batters, away_pitchers, home_batters, home_pitchers):
	away_batters=away_batters[['jerseyNumber','name','posnum']]
	away_batters=away_batters.fillna("")
	
	print("")
	bold("Away Lineup")
	table = PrettyTable()
	table.field_names = ["No", "Name", "Pos"]
	
	for row in away_batters.itertuples(index=False):
		table.add_row(row)

	print(table)
	
	away_pitchers=away_pitchers[['jerseyNumber','name']]
	away_pitchers=away_pitchers.fillna("")
	
	print("")
	bold("Away Pitcher")
	table = PrettyTable()
	table.field_names = ["No", "Name"]
	
	for row in away_pitchers.itertuples(index=False):
		table.add_row(row)

	print(table)
	
	home_batters=home_batters[['jerseyNumber','name','posnum']]
	home_batters=home_batters.fillna("")
	
	print("")
	bold("Home Lineup")
	table = PrettyTable()
	table.field_names = ["No", "Name", "Pos"]
	
	for row in home_batters.itertuples(index=False):
		table.add_row(row)

	print(table)
	
	home_pitchers=home_pitchers[['jerseyNumber','name']]
	home_pitchers=home_pitchers.fillna("")
	
	print("")
	bold("Home Pitcher")
	table = PrettyTable()
	table.field_names = ["No", "Name"]
	
	for row in home_pitchers.itertuples(index=False):
		table.add_row(row)

	print(table)
	
def present_batters(batters):
	tex_contents=""
	batters=batters.fillna("")
	for batter in batters.itertuples(index=False):
		if batter.Bats=="R":	
			tex_contents=tex_contents+"\\ "+batter.jerseyNumber+" & \\ "+batter.name+" & \\ "+batter.posnum+" & & & & & & & & & & & & & &    \\\\\n" 
		elif batter.Bats=="L":
			tex_contents=tex_contents+"\\ {\\color{blue}"+batter.jerseyNumber+"} & \\ {\\color{blue}"+batter.name+"} & \\ {\\color{blue}"+batter.posnum+"} & & & & & & & & & & & & & &    \\\\\n" 
		elif batter.Bats=="S":
			tex_contents=tex_contents+"\\ {\\color{red}"+batter.jerseyNumber+"} & \\ {\\color{red}"+batter.name+"} & \\ {\\color{red}"+batter.posnum+"} & & & & & & & & & & & & & &    \\\\\n" 
		else:
			tex_contents=tex_contents+"\\ {\\color{violet}"+batter.jerseyNumber+"} & \\ {\\color{violet}"+batter.name+"} & \\ {\\color{violet}"+batter.posnum+"} & & & & & & & & & & & & & &    \\\\\n" 
		tex_contents=tex_contents+"& & & & & & & & & & & & & & & &   \\\\\n & & & & & & & & & & & & & & & &   \\\\\n\\hline\n"
		
	return tex_contents
	
def present_pitchers(pitchers):
	tex_contents=""
	pitchers=pitchers.fillna("")
	for pitcher in pitchers.itertuples(index=False):
		if pitcher.Throws=="R":
			tex_contents=tex_contents+"\\ "+pitcher.jerseyNumber+" & \\ "+pitcher.name+ " & & & & & &   \\\\\n"
		elif pitcher.Throws=="L":
			tex_contents=tex_contents+"\\ {\\color{blue}"+pitcher.jerseyNumber+"} & \\ {\\color{blue}"+pitcher.name+ "} & & & & & &   \\\\\n"
		else:
			tex_contents=tex_contents+"\\ {\\color{violet}"+pitcher.jerseyNumber+"} & \\ {\\color{violet}"+pitcher.name+ "} & & & & & &   \\\\\n"
			
	return tex_contents
	
def split_rosters(away_roster, home_roster):
	away_roster["int_num"] = (
    away_roster["jerseyNumber"]
      .replace(["","--"], pd.NA)
      .astype("Int64")   # nullable integer dtype
	)
	
	home_roster["int_num"] = (
    home_roster["jerseyNumber"]
      .replace(["","--"], pd.NA)
      .astype("Int64")   # nullable integer dtype
	)
	
	away_infielders=away_roster[away_roster['position_type']=='Infielder'].sort_values('int_num').reset_index(drop=True)
	away_outfielders=away_roster[away_roster['position_type'].isin(['Outfielder','Two-Way Player'])].sort_values('int_num').reset_index(drop=True)
	away_catchers=away_roster[away_roster['position_type']=='Catcher'].sort_values('int_num').reset_index(drop=True)
	away_pitchers=away_roster[away_roster['position_type'].isin(['Pitcher','Two-Way Player'])].sort_values('int_num').reset_index(drop=True)
	
	home_infielders=home_roster[home_roster['position_type']=='Infielder'].sort_values('int_num').reset_index(drop=True)
	home_outfielders=home_roster[home_roster['position_type'].isin(['Outfielder','Two-Way Player'])].sort_values('int_num').reset_index(drop=True)
	home_catchers=home_roster[home_roster['position_type']=='Catcher'].sort_values('int_num').reset_index(drop=True)
	home_pitchers=home_roster[home_roster['position_type'].isin(['Pitcher','Two-Way Player'])].sort_values('int_num').reset_index(drop=True)
	
	return away_infielders, away_outfielders, away_catchers, away_pitchers, home_infielders, home_outfielders, home_catchers, home_pitchers

def safe_int(x):
    return int(x) if x != '' else 0
	
def extract_stat(df, row, col, isint=1, default=''):
	if col in df.columns and 0 <= row < len(df):
		if isint==1:
			return str(safe_int(df.loc[row, col]))
		else:
			return str(df.loc[row, col])
	return default
	
def present_rosters_stats(away_roster, home_roster, game):
	tex_contents=""
	tex_contents+="\\newsavebox{\\FitTableBox}\n\\newlength{\\FitTableScaleW}\n\\newlength{\\FitTableScaleH}\n\\newcommand{\\FitTable}[3]{%\n\\sbox{\\FitTableBox}{#3}%\n\\edef\\FitScaleW{\\fpeval{(#1)/(\\wd\\FitTableBox)}}%\n\\edef\\FitScaleH{\\fpeval{(#2)/(\\ht\\FitTableBox + \\dp\\FitTableBox)}}%\n\\edef\\FitScale{\\fpeval{min(\\FitScaleW,\\FitScaleH,1)}}%\n\\scalebox{\\FitScale}{\\usebox{\\FitTableBox}}%\n}\n"

	tex_contents+="\\pagebreak \n\n \\vspace*{\\fill} \n\n \\begin{center}\n\\FitTable{10.75in}{7.5in}{\n\\setlength{\\tabcolsep}{6pt}\n"
	tex_contents+="\\begin{tabular}{rlrrrrrrrrrrlrrrrrrrrr}\n"
	tex_contents+="\\multicolumn{11}{c}{\\bf "+game['Away Team']+" ("+str(game['away_record']['wins'])+"-"+str(game['away_record']['losses'])+")} & \\multicolumn{11}{c}{\\bf "+game['Home Team']+" ("+str(game['home_record']['wins'])+"-"+str(game['home_record']['losses'])+")}\\\\\n"
	tex_contents+="\\cmidrule(lr){1-11} \\cmidrule(lr){12-22}\n"
	tex_contents+=" & & & \\multicolumn{1}{c}{PA} & \\multicolumn{1}{c}{Avg} & \\multicolumn{1}{c}{OBP} & \\multicolumn{1}{c}{Slg} & \\multicolumn{1}{c}{OPS} & \\multicolumn{1}{c}{RBI} & \\multicolumn{1}{c}{HR} & \\multicolumn{1}{c}{SB} & & & & \\multicolumn{1}{c}{PA} & \\multicolumn{1}{c}{Avg} & \\multicolumn{1}{c}{OBP} & \\multicolumn{1}{c}{Slg} & \\multicolumn{1}{c}{OPS} & \\multicolumn{1}{c}{RBI} & \\multicolumn{1}{c}{HR} & \\multicolumn{1}{c}{SB} \\\\\n"
	
	away_infielders, away_outfielders, away_catchers, away_pitchers, home_infielders, home_outfielders, home_catchers, home_pitchers = split_rosters(away_roster, home_roster)
	
	if 'saves_p' in away_pitchers.columns and 'saveOpportunities_p' in away_pitchers.columns:
		away_pitchers['save_pct'] = (
		    pd.to_numeric(away_pitchers['saves_p'], errors='coerce')
		    / pd.to_numeric(away_pitchers['saveOpportunities_p'], errors='coerce').replace(0, pd.NA)
		).map(lambda x: f"{x:.3f}".lstrip("0") if pd.notna(x) else "")
		
	if 'saves_p' in home_pitchers.columns and 'saveOpportunities_p' in home_pitchers.columns:
		home_pitchers['save_pct'] = (
		    pd.to_numeric(home_pitchers['saves_p'], errors='coerce')
		    / pd.to_numeric(home_pitchers['saveOpportunities_p'], errors='coerce').replace(0, pd.NA)
		).map(lambda x: f"{x:.3f}".lstrip("0") if pd.notna(x) else "")
			
	tex_contents+="\\multicolumn{11}{l}{\\emph{Infielders}} &  \\multicolumn{11}{l}{\\emph{Infielders}} \\\\\n"
	how_many=max(len(away_infielders),len(home_infielders))
	for i in range(0,how_many):
		tex_contents=tex_contents+"{ "
		if extract(away_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_infielders,i,'jerseyNumber')+" } & { "
		if extract(away_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_infielders,i,'Name')+" } & {"
		if extract(away_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_infielders,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(away_infielders,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(away_infielders,i,'avg',0)+" & "
		tex_contents+=extract_stat(away_infielders,i,'obp',0)+" & "
		tex_contents+=extract_stat(away_infielders,i,'slg',0)+" & "
		tex_contents+=extract_stat(away_infielders,i,'ops',0)+" & "
		tex_contents+=extract_stat(away_infielders,i,'rbi')+" & "
		tex_contents+=extract_stat(away_infielders,i,'homeRuns')+" & "
		tex_contents+=extract_stat(away_infielders,i,'stolenBases')+" & "
		
		tex_contents=tex_contents+"{ "
		if extract(home_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_infielders,i,'jerseyNumber')+" } & { "
		if extract(home_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_infielders,i,'Name')+" } & {"
		if extract(home_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_infielders,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(home_infielders,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(home_infielders,i,'avg',0)+" & "
		tex_contents+=extract_stat(home_infielders,i,'obp',0)+" & "
		tex_contents+=extract_stat(home_infielders,i,'slg',0)+" & "
		tex_contents+=extract_stat(home_infielders,i,'ops',0)+" & "
		tex_contents+=extract_stat(home_infielders,i,'rbi')+" & "
		tex_contents+=extract_stat(home_infielders,i,'homeRuns')+" & "
		tex_contents+=extract_stat(home_infielders,i,'stolenBases')
		
		tex_contents+=" \\\\\n"
		
	tex_contents+=" \\\\\n"
	tex_contents+="\\multicolumn{11}{l}{\\emph{Outfielders}} &  \\multicolumn{11}{l}{\\emph{Outfielders}} \\\\\n"
	how_many=max(len(away_outfielders),len(home_outfielders))
	for i in range(0,how_many):
		tex_contents=tex_contents+"{ "
		if extract(away_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_outfielders,i,'jerseyNumber')+" } & { "
		if extract(away_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_outfielders,i,'Name')+" } & {"
		if extract(away_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_outfielders,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(away_outfielders,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(away_outfielders,i,'avg',0)+" & "
		tex_contents+=extract_stat(away_outfielders,i,'obp',0)+" & "
		tex_contents+=extract_stat(away_outfielders,i,'slg',0)+" & "
		tex_contents+=extract_stat(away_outfielders,i,'ops',0)+" & "
		tex_contents+=extract_stat(away_outfielders,i,'rbi')+" & "
		tex_contents+=extract_stat(away_outfielders,i,'homeRuns')+" & "
		tex_contents+=extract_stat(away_outfielders,i,'stolenBases')+" & "
		
		tex_contents=tex_contents+"{ "
		if extract(home_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_outfielders,i,'jerseyNumber')+" } & { "
		if extract(home_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_outfielders,i,'Name')+" } & {"
		if extract(home_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_outfielders,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(home_outfielders,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(home_outfielders,i,'avg',0)+" & "
		tex_contents+=extract_stat(home_outfielders,i,'obp',0)+" & "
		tex_contents+=extract_stat(home_outfielders,i,'slg',0)+" & "
		tex_contents+=extract_stat(home_outfielders,i,'ops',0)+" & "
		tex_contents+=extract_stat(home_outfielders,i,'rbi')+" & "
		tex_contents+=extract_stat(home_outfielders,i,'homeRuns')+" & "
		tex_contents+=extract_stat(home_outfielders,i,'stolenBases')
		
		tex_contents+=" \\\\\n"
	
	tex_contents+=" \\\\\n"
	tex_contents+="\\multicolumn{11}{l}{\\emph{Catchers}} &  \\multicolumn{11}{l}{\\emph{Catchers}} \\\\\n"
	how_many=max(len(away_catchers),len(home_catchers))
	for i in range(0,how_many):
		tex_contents=tex_contents+"{ "
		if extract(away_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_catchers,i,'jerseyNumber')+" } & { "
		if extract(away_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_catchers,i,'Name')+" } & {"
		if extract(away_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_catchers,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(away_catchers,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(away_catchers,i,'avg',0)+" & "
		tex_contents+=extract_stat(away_catchers,i,'obp',0)+" & "
		tex_contents+=extract_stat(away_catchers,i,'slg',0)+" & "
		tex_contents+=extract_stat(away_catchers,i,'ops',0)+" & "
		tex_contents+=extract_stat(away_catchers,i,'rbi')+" & "
		tex_contents+=extract_stat(away_catchers,i,'homeRuns')+" & "
		tex_contents+=extract_stat(away_catchers,i,'stolenBases')+" & "
		
		tex_contents=tex_contents+"{ "
		if extract(home_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_catchers,i,'jerseyNumber')+" } & { "
		if extract(home_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_catchers,i,'Name')+" } & {"
		if extract(home_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_catchers,i,'PrimPos')+" } & "
		tex_contents+=extract_stat(home_catchers,i,'plateAppearances')+ "& "
		tex_contents+=extract_stat(home_catchers,i,'avg',0)+" & "
		tex_contents+=extract_stat(home_catchers,i,'obp',0)+" & "
		tex_contents+=extract_stat(home_catchers,i,'slg',0)+" & "
		tex_contents+=extract_stat(home_catchers,i,'ops',0)+" & "
		tex_contents+=extract_stat(home_catchers,i,'rbi')+" & "
		tex_contents+=extract_stat(home_catchers,i,'homeRuns')+" & "
		tex_contents+=extract_stat(home_catchers,i,'stolenBases')
		
		tex_contents+=" \\\\\n"
		
	tex_contents+="\\hline\n \\addlinespace\n"
	#tex_contents+="\\multicolumn{11}{c}{"+game['Away Team']+"} & \\multicolumn{11}{c}{"+game['Home Team']+"}\\\\\n"
	#tex_contents+="\\cmidrule(lr){1-11} \\cmidrule(lr){12-22}\n"
	tex_contents+=" & & & \\multicolumn{1}{c}{IP} & \\multicolumn{1}{c}{ERA} & \\multicolumn{1}{c}{W} & \\multicolumn{1}{c}{L} & \\multicolumn{1}{c}{S} & \\multicolumn{1}{c}{S\%} & \\multicolumn{1}{c}{WHIP} & \\multicolumn{1}{c}{K} & & & & \\multicolumn{1}{c}{IP} & \\multicolumn{1}{c}{ERA} & \\multicolumn{1}{c}{W} & \\multicolumn{1}{c}{L} & \\multicolumn{1}{c}{S} & \\multicolumn{1}{c}{S\%} & \\multicolumn{1}{c}{WHIP}  & \\multicolumn{1}{c}{K} \\\\\n"
	
	tex_contents+="\\multicolumn{11}{l}{\\emph{Pitchers}} &  \\multicolumn{11}{l}{\\emph{Pitchers}} \\\\\n"
	how_many=max(len(away_pitchers),len(home_pitchers))
	for i in range(0,how_many):
		tex_contents=tex_contents+"{ "
		if extract(away_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_pitchers,i,'Throws',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_pitchers,i,'jerseyNumber')+" } & { "
		if extract(away_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_pitchers,i,'Throws',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_pitchers,i,'Name')+" } & & "
		tex_contents+=extract_stat(away_pitchers,i,'inningsPitched_p',0)+ "& "
		tex_contents+=extract_stat(away_pitchers,i,'era_p',0)+" & "
		tex_contents+=extract_stat(away_pitchers,i,'wins_p')+" & "
		tex_contents+=extract_stat(away_pitchers,i,'losses_p')+" & "
		tex_contents+=extract_stat(away_pitchers,i,'saves_p')+" & "
		tex_contents+=extract_stat(away_pitchers,i,'save_pct',0)+" & "
		tex_contents+=extract_stat(away_pitchers,i,'whip_p',0)+" & "
		tex_contents+=extract_stat(away_pitchers,i,'strikeOuts_p')+ " & "
		
		tex_contents=tex_contents+"{ "
		if extract(home_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_pitchers,i,'Throws',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_pitchers,i,'jerseyNumber')+" } & { "
		if extract(home_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_pitchers,i,'Throws',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_pitchers,i,'Name')+" } & & "
		tex_contents+=extract_stat(home_pitchers,i,'inningsPitched_p',0)+ "& "
		tex_contents+=extract_stat(home_pitchers,i,'era_p',0)+" & "
		tex_contents+=extract_stat(home_pitchers,i,'wins_p')+" & "
		tex_contents+=extract_stat(home_pitchers,i,'losses_p')+" & "
		tex_contents+=extract_stat(home_pitchers,i,'saves_p')+" & "
		tex_contents+=extract_stat(home_pitchers,i,'save_pct',0)+" & "
		tex_contents+=extract_stat(home_pitchers,i,'whip_p',0)+" & "
		tex_contents+=extract_stat(home_pitchers,i,'strikeOuts_p')
		
		tex_contents+=" \\\\\n"
		
	tex_contents+="\\hline \n \\end{tabular} \n } \n\\end{center} \n \\vspace*{\\fill}\n"

	return tex_contents	
					
def present_rosters(away_roster, home_roster, game, sportID, show_logos):
	tex_contents=""
	
	away_infielders, away_outfielders, away_catchers, away_pitchers, home_infielders, home_outfielders, home_catchers, home_pitchers = split_rosters(away_roster, home_roster)
	
	away_league=statsapi.get("team",{"teamId":game['Away Team ID']})['teams'][0]['league']['name']
	home_league=statsapi.get("team",{"teamId":game['Home Team ID']})['teams'][0]['league']['name']
	
	tex_contents=tex_contents+"\\pagebreak\n\\vspace*{\\fill}\n\\begin{center}\n\\setlength{\\tabcolsep}{10pt}\n\\setlength{\\parindent}{10pt}\n\\resizebox{\\textwidth}{!}{\n\\begin{tikzpicture}[font=\\sffamily]\n\\node (table) [inner sep=0pt] {\n\\begin{tabular}{cc|cc|cc|cc|cc|cc|cc|cc}\n"
	if show_logos==1 and sportID in [1,11,12,13,14,17,23,51]:
		tex_contents=tex_contents+"\\multicolumn{16}{c}{"
		if sportID in [1,51]:
			tex_contents+="\\includegraphics[width=1in]{MLB.png}"
		elif sportID in [11,12,13,14]:
			tex_contents+="\\includegraphics[width=1in]{MILB.png}"
		elif sportID==17:
			tex_contents+="\\includegraphics[width=1in]{Caribbean Series.png}"
		elif sportID==23:
			tex_contents+="\\includegraphics[width=1in]{LMB.png}"
		tex_contents+="} \\\\\n"
		tex_contents=tex_contents+"\\multicolumn{8}{c}{"
		tex_contents+="\\includegraphics[width=1in]{"
		tex_contents+=away_league
		tex_contents=tex_contents+".png}"
		tex_contents+="} & \\multicolumn{8}{c}{"
		tex_contents+="\\includegraphics[width=1in]{"
		tex_contents+=home_league
		tex_contents=tex_contents+".png}"
		tex_contents+="} \\\\\n"
		tex_contents=tex_contents+" \\multicolumn{16}{c}{\\ } \\\\\n"
		tex_contents=tex_contents+"\\multicolumn{8}{c}{"
		tex_contents+="\\includegraphics[height=1.75in,width=2in,keepaspectratio]{"+game['Away Team']+".png}"
		tex_contents+="} &\\multicolumn{8}{c}{"
		tex_contents+="\\includegraphics[height=1.75in,width=2in,keepaspectratio]{"+game['Home Team']+".png}"
		tex_contents+="} \\\\\n"
	else:
		tex_contents+="\\multicolumn{8}{c}" 
		tex_contents+="{\\Large \\bf "+game['Away Team']+"}"		
		tex_contents+=" & \\multicolumn{8}{c}" 
		tex_contents+="{\\Large \\bf "+game['Home Team']+"}"
		tex_contents+="\\\\\n\\addlinespace\n"
		tex_contents+="\\multicolumn{8}{c}{\\Large ("+str(game['away_record']['wins'])+"-"+str(game['away_record']['losses'])+")} "
		tex_contents+=" & " 
		tex_contents+="\\multicolumn{8}{c}{\\Large ("+str(game['home_record']['wins'])+"-"+str(game['home_record']['losses'])+")} "
		tex_contents+="\\\\\n"
		
	tex_contents=tex_contents+" \\multicolumn{16}{c}{\\ } \\\\\n"
	tex_contents=tex_contents+"\\cmidrule(lr){1-8} \\cmidrule(lr){9-16}\n"
	tex_contents=tex_contents+" \\multicolumn{16}{c}{\\ } \\\\\n"
	tex_contents=tex_contents+"\\multicolumn{2}{c}{\\textbf{\\Large Infielders}} & \\multicolumn{2}{c}{\\textbf{\\Large Outfielders}}  & \\multicolumn{2}{c}{\\textbf{\\Large Pitchers}} & \\multicolumn{2}{c|}{\\textbf{\\Large Catchers}} & \\multicolumn{2}{c}{\\textbf{\\Large Infielders}} & \\multicolumn{2}{c}{\\textbf{\\Large Outfielders}}  & \\multicolumn{2}{c}{\\textbf{\\Large Pitchers}} & \\multicolumn{2}{c}{\\textbf{\\Large Catchers}} \\\\ \\hline\n"
	tex_contents=tex_contents+" & & & & & & & & & & & & & & & \\\\\n"
	
	for i in range(0,len(home_pitchers)):
		tex_contents=tex_contents+"{\\Large "
		if extract(away_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_infielders,i,'jerseyNumber')+" } & {\\Large "
		if extract(away_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_infielders,i,'Name')+" } & {\\Large "
		
		if extract(away_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_outfielders,i,'jerseyNumber')+" } & {\\Large "
		if extract(away_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_outfielders,i,'Name')+" } & {\\Large "
		
		if extract(away_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		tex_contents=tex_contents+extract(away_pitchers,i,'jerseyNumber')+" } & {\\Large "
		if extract(away_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		tex_contents=tex_contents+extract(away_pitchers,i,'Name')+" } & {\\Large "
		
		if extract(away_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_catchers,i,'jerseyNumber')+" } & {\\Large "
		if extract(away_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(away_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(away_catchers,i,'Name')+" } & {\\Large "
		
		if extract(home_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_infielders,i,'jerseyNumber')+" } & {\\Large "
		if extract(home_infielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_infielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_infielders,i,'Name')+" } & {\\Large "
		
		if extract(home_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_outfielders,i,'jerseyNumber')+" } & {\\Large "
		if extract(home_outfielders,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_outfielders,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_outfielders,i,'Name')+" } & {\\Large "
		
		if extract(home_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		tex_contents=tex_contents+extract(home_pitchers,i,'jerseyNumber')+" } & {\\Large "
		if extract(home_pitchers,i,'Throws',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		tex_contents=tex_contents+extract(home_pitchers,i,'Name')+" } & {\\Large "
		
		if extract(home_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_catchers,i,'jerseyNumber')+" } & {\\Large "
		if extract(home_catchers,i,'Bats',default='R')=="L":
			tex_contents=tex_contents+"\\color{blue} "
		if extract(home_catchers,i,'Bats',default='R')=="S":
			tex_contents=tex_contents+"\\color{red} "
		tex_contents=tex_contents+extract(home_catchers,i,'Name')+" } \\\\\n"
		
	tex_contents=tex_contents+"\\end{tabular}\n};\n\\end{tikzpicture}\n}\n\\end{center}\n\\vspace*{\\fill}\n"
	
	return tex_contents
	
def present_game_info(game,month_str, day, year, away):
	tex_contents=""
	tex_contents=tex_contents+"\\node (table) [inner sep=0pt] {\\begin{tabular}{ccc}\n& {\\Large "
	if away==1:
		tex_contents+="\\bf "
	tex_contents+=game['Away Team']+"} & \\\\\n"
	tex_contents=tex_contents+"& {\\Large ("+str(game['away_record']['wins'])+"-"+str(game['away_record']['losses'])+") } & \\\\\n\\\\\n"
	tex_contents=tex_contents+"\\hspace{1in} & {\\Large at }  & \\hspace{1in} \\\\\n\\\\\n"
	tex_contents=tex_contents+" & {\\Large "
	if away==0:
		tex_contents+="\\bf "
	tex_contents+=game['Home Team']+"} & \\\\\n"
	tex_contents=tex_contents+"& {\\Large ("+str(game['home_record']['wins'])+"-"+str(game['home_record']['losses'])+") } & \\\\\n\\\\\n"
	tex_contents=tex_contents+" & {\\Large \\bf "+month_str+" "+day+", "+year+"} &\\\\\n\\\\\n\\\\\n\\\\\n"
	tex_contents+="\\end{tabular}\n};"
	
	return tex_contents
	
def create_latex(away_batters, home_batters, away_pitchers, home_pitchers, away_team_roster, home_team_roster, game, sportID, month_str, day, year, full_stats, show_logos):
	#print(game)
	#stop=input("")
	
	away_league=statsapi.get("team",{"teamId":game['Away Team ID']})['teams'][0]['league']['name']
	home_league=statsapi.get("team",{"teamId":game['Home Team ID']})['teams'][0]['league']['name']
	
	tex_contents=""
	tex_contents=tex_contents+"\\documentclass{article}\n\\usepackage{multirow,multicol,graphicx,longtable,pbox,booktabs,enumitem,amsmath,graphicx,enumitem,footnote,amsmath,amsthm,amssymb,setspace,float,boldline,array,multirow,diagbox,adjustbox,calc,xfp}\n\\usepackage[paperheight=8.5in,paperwidth=11in,margin=5mm]{geometry}\n \\usepackage{enumitem,tikz,float,siunitx,subcaption,amsmath,pgfplots}\n \\usepackage{helvet}\n\\begin{document}\n"
	tex_contents=tex_contents+"\\setlength{\\tabcolsep}{0pt}\n\\setlength{\\parindent}{0pt}\n\\renewcommand{\\familydefault}{\\sfdefault}\n"
	tex_contents=tex_contents+"\\begin{tikzpicture}[font=\\sffamily]\n\\node (table) [inner sep=0pt] {\n\\begin{tabular}{|p{.35in}|p{1.3in}|p{.35in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.35in}|p{.35in}|p{.35in}|p{.35in}|p{0in}}\n \\multicolumn{1}{c}{No} &  \\multicolumn{1}{c}{Player} &    \\multicolumn{1}{c}{Pos} &  \\multicolumn{1}{c}{1}&  \\multicolumn{1}{c}{2} &  \\multicolumn{1}{c}{3} &  \\multicolumn{1}{c}{4} &  \\multicolumn{1}{c}{5} &  \\multicolumn{1}{c}{6} & \\multicolumn{1}{c}{7} & \\multicolumn{1}{c}{8} &  \\multicolumn{1}{c}{9} &  \\multicolumn{1}{c}{10} &  \\multicolumn{1}{c}{AB} &  \\multicolumn{1}{c}{R} & \\multicolumn{1}{c}{H} &  \\multicolumn{1}{c}{RBI} & \\\\\n\\hline\n"
	
	tex_contents=tex_contents+present_batters(away_batters)
		
	tex_contents=tex_contents+"&  \\centering Totals R/H & & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & & & &   \\\\\n\\hline\n\\end{tabular}\n};\n\\end{tikzpicture}\n"
	tex_contents=tex_contents+"\n\n"
	tex_contents=tex_contents+"\\vspace*{\\baselineskip}\n\\begin{tikzpicture}[font=\\sffamily]\n\\node (table) [inner sep=0pt] {\n\\begin{tabular}{|p{.35in}|p{1.65in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{0in}}\n\\multicolumn{1}{c}{No} & \\multicolumn{1}{c}{Pitcher} &  \\multicolumn{1}{c}{IP} &  \\multicolumn{1}{c}{H} & \\multicolumn{1}{c}{R} &  \\multicolumn{1}{c}{ER} &  \\multicolumn{1}{c}{BB} & \\multicolumn{1}{c}{K} & \\\\\n\\hline\n"
	
	tex_contents=tex_contents+present_pitchers(away_pitchers)
	
	tex_contents=tex_contents+"& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n\\end{tabular}\n};\n\\end{tikzpicture}%\n\\hspace{10pt}\n\\begin{tikzpicture}[font=\\sffamily]\n"
	
	if sportID in [1,11,12,13,14,17,23,51] and show_logos==1: 
		tex_contents=tex_contents+"\\node (table) [inner sep=0pt] {\n\\begin{adjustbox}{max width=4in}\n\\begin{tabular}{ccccc}\n\\multicolumn{5}{c}{\\Large \\bf "+game['Away Team']+" at "+game['Home Team']+"}\\\\\n\\multicolumn{5}{c}{\\Large \\bf "+month_str+" "+day+", "+year+"}\\\\\n\\ \\\\\n"
		if sportID in [1,51]:
			tex_contents+="\\includegraphics[width=1in]{MLB.png} "
		elif sportID in [11,12,13,14]: 
			tex_contents+="\\includegraphics[width=1in]{MILB.png} "
		elif sportID==17:
			tex_contents+="\\includegraphics[width=1in]{Caribbean Series.png} "
		elif sportID==23:
			tex_contents+="\\includegraphics[width=1in]{LMB.png} "
		tex_contents+="&\\ \\  & "
		tex_contents+="\\includegraphics[height=1.75in,width=2in,keepaspectratio]{"+game['Away Team']+".png} "
		tex_contents+="&\\ \\  &  "
		tex_contents+="\\includegraphics[width=1in]{"
		tex_contents+=away_league
		tex_contents=tex_contents+".png}"
		tex_contents+="\n\\end{tabular}\n\\end{adjustbox}\n};"
	else:
		tex_contents=tex_contents+present_game_info(game,month_str, day, year,1)
		
	tex_contents=tex_contents+"\n\\end{tikzpicture}\n"
	
	tex_contents=tex_contents+"\n\n\\pagebreak\n\n"

	tex_contents=tex_contents+"\\begin{tikzpicture}[font=\\sffamily]\n\\node (table) [inner sep=0pt] {\n\\begin{tabular}{|p{.35in}|p{1.3in}|p{.35in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.35in}|p{.35in}|p{.35in}|p{.35in}|p{0in}}\n \\multicolumn{1}{c}{No} &  \\multicolumn{1}{c}{Player} &    \\multicolumn{1}{c}{Pos} &  \\multicolumn{1}{c}{1}&  \\multicolumn{1}{c}{2} &  \\multicolumn{1}{c}{3} &  \\multicolumn{1}{c}{4} &  \\multicolumn{1}{c}{5} &  \\multicolumn{1}{c}{6} & \\multicolumn{1}{c}{7} & \\multicolumn{1}{c}{8} &  \\multicolumn{1}{c}{9} &  \\multicolumn{1}{c}{10} &  \\multicolumn{1}{c}{AB} &  \\multicolumn{1}{c}{R} & \\multicolumn{1}{c}{H} &  \\multicolumn{1}{c}{RBI} & \\\\\n\\hline\n"
	
	tex_contents=tex_contents+present_batters(home_batters)
		
	tex_contents=tex_contents+"&  \\centering Totals R/H & & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & \\diagbox[innerwidth=.7in,height=3\\line,dir=NE]{}{} & & & &   \\\\\n\\hline\n\\end{tabular}\n};\n\\end{tikzpicture}\n"
	tex_contents=tex_contents+"\n\n"
	tex_contents=tex_contents+"\\vspace*{\\baselineskip}\n\\begin{tikzpicture}[font=\\sffamily]\n\\node (table) [inner sep=0pt] {\n\\begin{tabular}{|p{.35in}|p{1.65in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{.7in}|p{0in}}\n\\multicolumn{1}{c}{No} & \\multicolumn{1}{c}{Pitcher} &  \\multicolumn{1}{c}{IP} &  \\multicolumn{1}{c}{H} & \\multicolumn{1}{c}{R} &  \\multicolumn{1}{c}{ER} &  \\multicolumn{1}{c}{BB} & \\multicolumn{1}{c}{K} & \\\\\n\\hline\n"
	
	tex_contents=tex_contents+present_pitchers(home_pitchers)
	
	tex_contents=tex_contents+"& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n& & & & & & &   \\\\\n& & & & & & &   \\\\\n\\hline\n\\end{tabular}\n};\n\\end{tikzpicture}%\n\\hspace{10pt}\n\\begin{tikzpicture}[font=\\sffamily]\n"
	
	if sportID in [1,11,12,13,14,17,23,51] and show_logos==1:
		tex_contents=tex_contents+"\\node (table) [inner sep=0pt] {\n\\begin{adjustbox}{max width=4in}\n\\begin{tabular}{ccccc}\n\\multicolumn{5}{c}{\\Large \\bf "+game['Away Team']+" at "+game['Home Team']+"}\\\\\n\\multicolumn{5}{c}{\\Large \\bf "+month_str+" "+day+", "+year+"}\\\\\n\\ \\\\\n"
		if sportID in [1,51]:
			tex_contents+="\\includegraphics[width=1in]{MLB.png} "
		elif sportID in [11,12,13,14]:
			tex_contents+="\\includegraphics[width=1in]{MILB.png} "
		elif sportID==17:
			tex_contents+="\\includegraphics[width=1in]{Caribbean Series.png} "
		elif sportID==23:
			tex_contents+="\\includegraphics[width=1in]{LMB.png} "
		tex_contents+="&\\ \\  & "
		tex_contents+="\\includegraphics[height=1.75in,width=2in,keepaspectratio]{"+game['Home Team']+".png} "
		tex_contents+="&\\ \\  &  "
		tex_contents+="\\includegraphics[width=1in]{"
		tex_contents+=home_league
		tex_contents=tex_contents+".png}"
		tex_contents+="\n\\end{tabular}\n\\end{adjustbox}\n};"
	else:
		tex_contents=tex_contents+present_game_info(game,month_str, day, year,0)
		
	tex_contents=tex_contents+"\n\\end{tikzpicture}\n"
	
	tex_contents=tex_contents+"\n\n"
	
	if full_stats==0:
		tex_contents=tex_contents+present_rosters(away_team_roster, home_team_roster, game, sportID, show_logos)
	elif full_stats==1:
		tex_contents=tex_contents+present_rosters_stats(away_team_roster, home_team_roster, game)
		
	tex_contents=tex_contents+"\n\\end{document}"
		
	return tex_contents
	